/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.BlockIDListSumBean;
import com.ibm.hwmca.base.logd.ClassSelectionBean;
import com.ibm.hwmca.base.logd.CreateEventLogData;
import com.ibm.hwmca.base.logd.EventLogData;
import com.ibm.hwmca.base.logd.EventLogSearch;
import com.ibm.hwmca.base.logd.EventLogSearchInfo;
import com.ibm.hwmca.base.logd.EventLogSummaryBean;
import com.ibm.hwmca.base.logd.EventLogSummaryInfo;
import com.ibm.hwmca.base.logd.FileBean;
import com.ibm.hwmca.base.logd.FileDisplayerBean;
import com.ibm.hwmca.base.logd.FileFn;
import com.ibm.hwmca.base.logd.LogDisplayer;
import com.ibm.hwmca.base.logd.LogDisplayerLaunch;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.logd.RetrieveRefcode;
import com.ibm.hwmca.base.logd.SecondaryBlockIDSumBean;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.log.LoggerTasklet;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.pa.fedc.LogCollectionAgent;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class EventLogSummaryTasklet
extends PanelTasklet
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDTET";
    private static final String TRACE_MASKF = "XLOGDTEF";
    private static final String TRACE_MASKD = "XLOGDTED";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.logd.res.LogDisplayerRes";
    private static final String EVENT_LOG_SUMMARY_PANEL_NAME = "EventLogSummaryPanel";
    private static final String BLOCKID_PANEL_NAME = "BlockIDListSumPanel";
    private static final String SECONDARY_BLOCKID_PANEL_NAME = "SecondaryBlockIDSumPanel";
    private static final String FILE_PANEL_NAME = "FilePanel";
    private static final String CLASS_LIST_PANEL_NAME = "ClassSelectionPanel";
    private static final String FILE_LIST_PANEL_NAME = "FileDisplayerPanel";
    private static final int MAX_NUMBER_FORMATTED_EVENT_LOGS = 100;
    private static final int ACTION_NO_ACTION = 1;
    private static final int ACTION_DISPOSE = 2;
    private static final int ACTION_TERMINATE = 3;
    private int _numFormattedEventLogs;
    private int _numEventLogs;
    private String _logName;
    private String _logNameBak;
    private boolean _aLogPanelDisplayed;
    private boolean _defaultLogFileDisplayed;
    private boolean _backUpDefaultLogFileDisplayed;
    private int _eventSelected;
    private Integer[] _selFile;
    private String _fileDisplayerBeanName;
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    private static final LocalizableText _lEventTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.eventsummary.title");
    private static final LocalizableText _lFileTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.file.title");
    private static final LocalizableText _lStrBusy = new LocalizableText(BaseTextBundle.getBundleName(), "logd.eventsummary.busy");
    private LocalizableText _lBlkTitle;
    private LocalizableText _lSecBlkTitle;
    private EventLogSummaryInfo _eventLogSummaryInfo;
    private BlockIDListSumBean _blockIDListSumBean;
    private EventLogSummaryBean _eventLogSummaryBean;
    private Log[] _logData;
    private Log _logSelected;
    private LogBlock[] _logBlocks;
    private ArrayList _logSecondaryBlocks;
    private CreateEventLogData _createEventLogData = new CreateEventLogData();
    private SecondaryBlockIDSumBean _secondaryBlockIDSumBean;
    private EventLogData _selectedEventLogData;
    private static boolean _refcodeProgramExists;
    private ArrayList _classList;
    private String[] _fileList;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$log$LogClass;

    public EventLogSummaryTasklet() {
        Trace.trace(TRACE_MASKT, "<-> EventLogSummaryTasklet constructor");
        this._aLogPanelDisplayed = false;
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> EventLogSummaryTasklet.service()");
        if (taskletRequest.isSynchronous()) {
            Trace.trace(TRACE_MASKF, "in event log's synchronous processing");
            String action = (String)taskletRequest.getData("action");
            Trace.trace(TRACE_MASKF, "synchronous action=" + action);
            if (action.equals("getData")) {
                Trace.trace(TRACE_MASKF, "in event log's synchronous processing numEvents=" + this._numEventLogs + " numFormatEventLogs=" + this._numFormattedEventLogs);
                Integer startIndx = (Integer)taskletRequest.getData("requestedIndex");
                int startIndex = startIndx;
                if (this._numEventLogs < startIndex + this._numFormattedEventLogs) {
                    startIndex = this._numEventLogs - this._numFormattedEventLogs;
                }
                Trace.trace(TRACE_MASKF, "NSYNC: startIndex=" + startIndex);
                this._createEventLogData.createEventLogData(this._logData, startIndex, this._eventLogSummaryInfo.getEventLogData());
                this._eventLogSummaryInfo.setStartIndex(startIndex);
                taskletResponse.setData("eventLogSummary", this._eventLogSummaryInfo);
                Trace.trace(TRACE_MASKF, "NSYNC: sent startIndex=" + startIndex + " eventLogData to bean");
                taskletResponse.noAction();
            } else if (action.equals("search")) {
                Trace.trace(TRACE_MASKF, "in event log's synchronous search processing");
                EventLogSearchInfo eventLogSearchInfo = (EventLogSearchInfo)taskletRequest.getData("searchData");
                EventLogSearch eventLogSearch = new EventLogSearch(this, eventLogSearchInfo, this._logData);
                int searchIndex = eventLogSearch.doSearch();
                Integer sIndex = new Integer(searchIndex);
                taskletResponse.setData("searchIndex", sIndex);
                Trace.trace(TRACE_MASKF, "event log's search index returned=" + searchIndex);
                taskletResponse.noAction();
            }
        } else if (taskletRequest.isInitialRequest()) {
            Trace.trace(TRACE_MASKF, "in event log's InitialRequest");
            this._logName = (String)taskletRequest.getData("logFileName");
            if (this._logName == null || this._logName.length() == 0) {
                Trace.trace(TRACE_MASKF, "Will read default log file");
                this._defaultLogFileDisplayed = true;
                this.readThenDisplayLogs(taskletRequest, taskletResponse);
            } else {
                Trace.trace(TRACE_MASKF, "Will read log file=" + this._logName);
                this._defaultLogFileDisplayed = false;
                this.validateReadLogFileName(taskletRequest, taskletResponse, this._logName, 3);
            }
        } else if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
            Trace.trace(TRACE_MASKF, "before the log terminate");
            taskletResponse.terminate();
        } else {
            String panelError = (String)taskletRequest.getData("panelError");
            if (panelError == null) {
                TaskActionEvent event = (TaskActionEvent)taskletRequest.getData("event");
                String command = event.getActionCommand();
                String panelName = (String)taskletRequest.getData("panelName");
                Trace.trace(TRACE_MASKF, "Processing log: panelName=" + panelName + " command =" + command);
                if (command.equals("CANCEL")) {
                    if (panelName.equals("eventSummary")) {
                        taskletResponse.terminate();
                    } else {
                        taskletResponse.dispose();
                    }
                } else if (panelName.equals("eventSummary")) {
                    if (command.equals("CancelButton")) {
                        taskletResponse.terminate();
                    } else if (command.equals("RefreshButton") || command.equals("ViewMenu.AllClassesItem")) {
                        Trace.trace(TRACE_MASKF, "processing event log's cmd=" + command);
                        this.readThenDisplayLogs(taskletRequest, taskletResponse);
                    } else if (command.equals("OkButton") || command.endsWith("BlockIdItem")) {
                        Trace.trace(TRACE_MASKF, "processing event log's OK button or double click action");
                        this._logSelected = this.getSelectedLog(taskletRequest, taskletResponse, "okDoubleSel:");
                        if (this._logSelected != null) {
                            this.getThenDisplayBlocks(taskletRequest, taskletResponse);
                        }
                    } else if (command.equals("PurgeMenu.PurgeAllClassesItem")) {
                        Trace.trace(TRACE_MASKF, "processing event log's purge all classes");
                        this.purgeLogs();
                        this.readThenDisplayLogs(taskletRequest, taskletResponse);
                    } else if (command.equals("FileEventSumMenu.SaveLogListFileItem")) {
                        Trace.trace(TRACE_MASKF, "processing event log's save log list to file");
                        this.displayFileNamePanel(taskletRequest, taskletResponse, "FileNamePanelWrite");
                    } else if (command.equals("FileEventSumMenu.SpecifyLogFileNameItem")) {
                        Trace.trace(TRACE_MASKF, "processing event log's read new log file");
                        this.displayFileNamePanel(taskletRequest, taskletResponse, "FileNamePanelRead");
                    } else if (command.equals("ViewMenu.SelectedClassItem")) {
                        Trace.trace(TRACE_MASKF, "processing select list of log classes");
                        this.displayClassSelection(taskletResponse);
                    } else if (command.equals("DisplayRefcodeDescriptionMenu.DisplayRefcodeDescriptionItem")) {
                        Trace.trace(TRACE_MASKF, "processing display the refcode description item.");
                        this.handleRefcodeDisplayDesc(taskletRequest, taskletResponse);
                    } else if (command.equals("FileEventSumMenu.ViewDataFileListItem")) {
                        Trace.trace(TRACE_MASKF, "processing view file list item.");
                        this.displayViewFileList(taskletRequest, taskletResponse);
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown event received by the EventLogSummary panel. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                } else if (panelName.equals("blockId")) {
                    this._lBlkTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.blockid.title");
                    byte logClass = this._logSelected.getLogClass();
                    String logClassStr = HexString.toHex(logClass, true).toUpperCase();
                    byte logType = this._logSelected.getLogType();
                    String logTypeStr = HexString.toHex(logType, true).toUpperCase();
                    Trace.trace(TRACE_MASKF, "processing block id: Class=" + logClassStr + " Type=" + logTypeStr);
                    if (command.equals("OkButton")) {
                        Trace.trace(TRACE_MASKF, "Processing Block Id's OK request");
                        String userChoice = (String)taskletRequest.getData("radioButton");
                        Trace.trace(TRACE_MASKF, "radioButton selected=" + userChoice);
                        if (userChoice.equals("SecondaryDataBlockItem")) {
                            Trace.trace(TRACE_MASKF, "process radioButton=" + userChoice + " for panel=" + panelName);
                            this.getThenDisplaySecondaryBlocks(taskletRequest, taskletResponse);
                        } else {
                            Trace.trace(TRACE_MASKF, "Before call to launch subTasklet(not a secondary block");
                            LogDisplayerLaunch logDisplayerLaunch = new LogDisplayerLaunch(this._logSelected, taskletResponse);
                            logDisplayerLaunch.launchSubtasklet(userChoice);
                        }
                    } else if (command.equals("CancelButton")) {
                        Trace.trace(TRACE_MASKF, "processing the log block id's CANCEL request");
                        taskletResponse.dispose();
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown event received by the Block ID panel. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                } else if (panelName.equals("SecondaryBlockId")) {
                    Trace.trace(TRACE_MASKF, "Processing secondary log block request");
                    this._lSecBlkTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.secondaryblockId.title");
                    if (command.equals("OkButton")) {
                        Trace.trace(TRACE_MASKF, "Processing secondary log block's OK button.");
                        String selectStr = (String)taskletRequest.getData("secondaryBlockIdSelected");
                        Trace.trace(TRACE_MASKF, "charSecBlk selected=" + selectStr);
                        int secBlkSelected = Integer.valueOf(selectStr);
                        Trace.trace(TRACE_MASKF, "secBlk selected=" + secBlkSelected);
                        LogBlock logBlock = (LogBlock)this._logSecondaryBlocks.get(secBlkSelected);
                        Trace.trace(TRACE_MASKF, "Before call to launch subTasklet(secondary block");
                        LogDisplayerLaunch logDisplayerLaunch = new LogDisplayerLaunch(this._logSelected, taskletResponse);
                        logDisplayerLaunch.launchSubtasklet(logBlock);
                    } else if (command.equals("CancelButton")) {
                        taskletResponse.dispose();
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown event received by the Secondary Block ID panel. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                } else if (panelName.equals("FileNamePanelWrite")) {
                    if (command.equals("OkButton")) {
                        Trace.trace(TRACE_MASKF, "processing the file panel's OK request");
                        FileFn writeToFile = new FileFn();
                        try {
                            writeToFile.saveToFile((PanelTasklet)this, taskletRequest, taskletResponse, this._logData);
                        }
                        catch (HException hexc) {
                            Trace.trace(TRACE_MASKF, "HException caught in EventLogSummaryTasklet.service()");
                            Trace.trace(TRACE_MASKF, hexc);
                            TaskletException te = new TaskletException(hexc);
                            throw te;
                        }
                    } else if (command.equals("CancelButton")) {
                        Trace.trace(TRACE_MASKF, "processing the filePanelWrite's  CANCEL request");
                        taskletResponse.dispose();
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown event received by the filePanelWrite. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                } else if (panelName.equals("FileNamePanelRead")) {
                    if (command.equals("OkButton")) {
                        Trace.trace(TRACE_MASKF, "processing the filePanelRead's OK request");
                        String tmpLogName = (String)taskletRequest.getData("fileName");
                        tmpLogName = FileFn.fullyQualify(tmpLogName);
                        boolean fileExists = false;
                        boolean canRead = false;
                        boolean isFile = false;
                        boolean msgDisplayed = false;
                        String dev = null;
                        try {
                            FileFn fileFn = new FileFn();
                            dev = fileFn.queryMediaType(this, tmpLogName);
                            File f = new File(tmpLogName);
                            fileExists = f.exists();
                            canRead = f.canRead();
                            isFile = f.isFile();
                            Trace.trace(TRACE_MASKF, "fileExists=" + fileExists + " canRead=" + canRead + " isFile=" + isFile + "msgDisplayed=" + msgDisplayed);
                        }
                        catch (MediaServicesUtilException me) {
                            Trace.trace(TRACE_MASKF, "Err determining type of device from where to read the log file");
                            Trace.trace(TRACE_MASKF, me);
                            msgDisplayed = me.isErrorDisplayed();
                        }
                        if (dev == null && fileExists && canRead && isFile) {
                            this._logName = "!" + tmpLogName;
                            Trace.trace(TRACE_MASKF, "name of log file to read =" + this._logName);
                            this._defaultLogFileDisplayed = false;
                            this.readThenDisplayLogs(null, taskletRequest, taskletResponse, true);
                        } else if (!msgDisplayed) {
                            Trace.trace(TRACE_MASKF, "log file to read =" + tmpLogName + " not found or accesible");
                            LocalizableText lStrTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.filenameread.title");
                            BaseMessageText myMess = new BaseMessageText("LOGDNTFI");
                            this.showMessageBox(true, lStrTitle, myMess, null, null);
                            taskletResponse.noAction();
                        } else {
                            Trace.trace(TRACE_MASKF, "Media Services has displayed the error message already");
                            taskletResponse.noAction();
                        }
                    } else if (command.equals("CancelButton")) {
                        Trace.trace(TRACE_MASKF, "processing the filePanelRead's  CANCEL request");
                        taskletResponse.dispose();
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown event received by the filePanelRead. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                } else if (panelName.equals("ClassSelectionNamePanel")) {
                    if (command.equals("OkButton")) {
                        Trace.trace(TRACE_MASKF, "processing the class selection panel's OK request");
                        Integer[] sel = (Integer[])taskletRequest.getData("classSelected");
                        int numSelected = sel.length;
                        Byte[] classes = new Byte[numSelected];
                        int i = 0;
                        while (i < numSelected) {
                            classes[i] = (Byte)this._classList.get(sel[i] * 2);
                            Trace.trace(TRACE_MASKF, "selected logClass=" + HexString.toHex(classes[i]));
                            ++i;
                        }
                        this.readThenDisplayLogs(classes, taskletRequest, taskletResponse, true);
                    } else if (command.equals("CancelButton")) {
                        Trace.trace(TRACE_MASKF, "processing the class selection panel's  CANCEL request");
                        taskletResponse.dispose();
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown event received by the ClassSelection panel. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                } else if (panelName.equals("FileDisplayerNamePanel")) {
                    if (command.equals("SaveButton")) {
                        Trace.trace(TRACE_MASKF, "processing the view file list selection (SaveButton)Zip request");
                        this._selFile = (Integer[])taskletRequest.getData("selectedFilesListName");
                        int selLen = this._selFile.length;
                        int i = 0;
                        while (i < selLen) {
                            Trace.trace(TRACE_MASKF, "selected FileListIndex=" + HexString.toHex(this._selFile[i]));
                            ++i;
                        }
                        FileFn writeToFile = new FileFn();
                        try {
                            writeToFile.makeZipFile(this, taskletRequest, taskletResponse, this._fileList, this._selFile);
                        }
                        catch (IOException exc) {
                            Trace.trace(TRACE_MASKF, "There was an error creating the zip file");
                            TaskletException te = new TaskletException(exc);
                            throw te;
                        }
                        catch (HException he) {
                            Trace.trace(TRACE_MASKF, "There was an error while creating the zip file");
                            TaskletException texc = new TaskletException(he);
                            throw texc;
                        }
                    } else if (command.equals("CancelButton")) {
                        Trace.trace(TRACE_MASKF, "processing the view file list panel's  CANCEL request");
                        taskletResponse.dispose();
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown event received by the ClassSelection panel. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                } else if (panelName.equals("BadFilesNamePanel")) {
                    if (command.equals("OkButton")) {
                        Trace.trace(TRACE_MASKF, "processing the get the file name for the bad files panel");
                        taskletResponse.dispose(this._fileDisplayerBeanName);
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown event received when getting the bad files name. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                }
            } else {
                Trace.trace(TRACE_MASKF, "EventLogSummaryTasklet panelErr=" + panelError);
                taskletResponse.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- EventLogSummaryTasklet.service()");
    }

    private void readThenDisplayLogs(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        this.readThenDisplayLogs(null, taskletRequest, taskletResponse, false);
    }

    private void readThenDisplayLogs(Byte[] logClass, PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse, boolean multipleResponse) throws TaskletException {
        Trace.trace(TRACE_MASKF, " -> EventLogSummaryTasklet.readThenDisplayLogs()");
        Log[] logDataBak = null;
        this.showBusyDialog(_lEventTitle, _lStrBusy);
        boolean continueProcessing = true;
        try {
            logDataBak = this._logData;
            this._logData = this.getEventLogs(logClass);
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "Error reading the log file exc=" + e);
            new FrameworkLog(_logInfo, 1361, e).log();
            this.displayMsgRetrieveLogErr("LOGNORDAT");
            continueProcessing = false;
            taskletResponse.terminate();
        }
        if (continueProcessing) {
            this.destroyBusyDialog();
            this._numEventLogs = this._logData.length;
            Trace.trace(TRACE_MASKF, "Total number of event logs returned=" + this._numEventLogs);
            if (this._numEventLogs == 0) {
                Trace.trace(TRACE_MASKF, "There is no log data to display");
                BaseMessageText myMess = null;
                myMess = logClass == null ? new BaseMessageText("LOGNOLOG") : new BaseMessageText("LOGNCLOG");
                this.showMessageBox(true, _lEventTitle, myMess, null, null);
                if (!this._aLogPanelDisplayed) {
                    taskletResponse.terminate();
                } else {
                    this._logName = this._logNameBak;
                    this._logData = logDataBak;
                    this._numEventLogs = this._logData.length;
                    this._defaultLogFileDisplayed = this._backUpDefaultLogFileDisplayed;
                    Trace.trace(TRACE_MASKF, "Actual defaultLogFileDisplayed=" + this._defaultLogFileDisplayed);
                    taskletResponse.dispose();
                }
            } else {
                logDataBak = null;
                if (multipleResponse) {
                    taskletResponse.setMultipleResponseMode();
                    taskletResponse.dispose();
                }
                this.displayLogs(taskletResponse);
                this._aLogPanelDisplayed = true;
                this._backUpDefaultLogFileDisplayed = this._defaultLogFileDisplayed;
                this._logNameBak = this._logName;
            }
        }
        Trace.trace(TRACE_MASKF, " <- EventLogSummaryTasklet.readThenDisplayLogs()");
    }

    private void displayLogs(PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> EventLogSummaryTasklet.displayLogs()");
        this._eventLogSummaryBean = new EventLogSummaryBean();
        this._numFormattedEventLogs = this._numEventLogs < 100 ? this._numEventLogs : 100;
        Trace.trace(TRACE_MASKF, "number of formatted event logs=" + this._numFormattedEventLogs);
        this._eventLogSummaryInfo = new EventLogSummaryInfo(this._numEventLogs, this._numFormattedEventLogs, _refcodeProgramExists, this._defaultLogFileDisplayed);
        this._createEventLogData.createEventLogData(this._logData, 0, this._eventLogSummaryInfo.getEventLogData());
        this._eventLogSummaryBean.setEventLogSummaryInfo(this._eventLogSummaryInfo);
        Trace.trace(TRACE_MASKF, "before replace fn=EventLogSummaryPanel");
        taskletResponse.replace(AUIML_FILE_NAME, EVENT_LOG_SUMMARY_PANEL_NAME, this._eventLogSummaryBean);
        Trace.trace(TRACE_MASKF, "after replace fn=EventLogSummaryPanel");
        Trace.trace(TRACE_MASKF, "<- EventLogSummaryTasklet.displayLogs()");
    }

    private Log[] getEventLogs(Byte[] logClass) throws HException {
        Trace.trace(TRACE_MASKF, "-> EventLogSummaryTasklet.getEventLogs().");
        Trace.trace(TRACE_MASKF, "file name to read is [" + this._logName + "]");
        Trace.trace(TRACE_MASKF, "defaultLogFileNameToDisplay=" + this._defaultLogFileDisplayed);
        Log[] logs = null;
        logs = Log.retrieveSummary(logClass, null, null, null, this._logName);
        Trace.trace(TRACE_MASKF, "<- EventLogSummaryTasklet.getEventLogs(). file name to read is [" + this._logName + "]");
        return logs;
    }

    private Log getSelectedLog(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse, String whoCalled) throws TaskletException {
        Trace.trace(TRACE_MASKF, whoCalled + " -> getSelectedLog()");
        Log log = null;
        try {
            Integer sel = (Integer)taskletRequest.getData("selected");
            this._eventSelected = sel;
            Log cfr_ignored_0 = this._logData[this._eventSelected];
            log = Log.retrieve(this._logData[this._eventSelected].getLogEntryId());
            if (log == null) {
                Trace.trace(TRACE_MASKF, "Unable to read the log object.");
                this.displayMsgRetrieveLogErr("LOGNOADAT");
                taskletResponse.noAction();
            }
        }
        catch (HException hex) {
            Trace.trace(TRACE_MASKF, "Error reading the selected log block object");
            Trace.trace(TRACE_MASKF, hex);
            new FrameworkLog(_logInfo, 1370, hex).log();
            this.displayMsgRetrieveLogErr("LOGNOBDAT");
            taskletResponse.noAction();
        }
        Trace.trace(TRACE_MASKF, whoCalled + " <- getSelectedLog()");
        if (log == null) {
            return null;
        }
        return log;
    }

    private void purgeLogs() throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> EventLogSummaryTasklet.purgeLogs().");
        try {
            LoggerTasklet.purge("log");
        }
        catch (HException hexc) {
            Trace.trace(TRACE_MASKF, "There was an error purging the logs");
            TaskletException te = new TaskletException(hexc);
            throw te;
        }
        Trace.trace(TRACE_MASKF, "<- EventLogSummaryTasklet.purgeLogs().");
    }

    private void displayMsgRetrieveLogErr(String msg) throws TaskletException {
        BaseMessageText myMess = new BaseMessageText(msg);
        this.showMessageBox(true, _lEventTitle, myMess, MsgType.ERROR_MESSAGE, null);
    }

    private void getThenDisplayBlocks(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> EventLogSummaryTasklet.getThenDisplayBlocks().");
        this._blockIDListSumBean = new BlockIDListSumBean();
        this._logBlocks = this._logSelected.getLogBlocks();
        if (this._logBlocks == null || this._logBlocks.length == 0) {
            BaseMessageText myMess = new BaseMessageText("LOGNOBLK");
            Trace.trace(TRACE_MASKF, "No block data for selected log event");
            this.showMessageBox(true, _lEventTitle, myMess, null, null);
            taskletResponse.noAction();
        } else {
            this._blockIDListSumBean.setLogBlocks(this._logBlocks);
            this._blockIDListSumBean.setEventLogData(this._createEventLogData.createEventLogData(this._logSelected));
            taskletResponse.openModalChild(AUIML_FILE_NAME, BLOCKID_PANEL_NAME, this._blockIDListSumBean);
        }
        Trace.trace(TRACE_MASKF, "<-  EventLogSummaryTasklet.getThenDisplayBlocks().");
    }

    private void getSecondaryBlocks() {
        Trace.trace(TRACE_MASKF, " -> EventLogSummaryTasklet.getSecondaryBlocks()");
        this._logSecondaryBlocks = new ArrayList();
        int lowerSec = 4;
        int upperSec = -17;
        upperSec &= 0xFF;
        lowerSec &= 0xFF;
        int numberOfBlocks = this._logBlocks.length;
        int i = 0;
        while (i < numberOfBlocks) {
            int blockId = this._logBlocks[i].getBlockId();
            Trace.trace(TRACE_MASKF, " blockId=" + HexString.toHex((byte)blockId, true) + " num=" + numberOfBlocks);
            int tmpBlockId = blockId;
            if ((tmpBlockId &= 0xFF) >= lowerSec && tmpBlockId <= upperSec) {
                Trace.trace(TRACE_MASKF, " SecblockId=" + HexString.toHex(this._logBlocks[i].getBlockId()));
                this._logSecondaryBlocks.add(this._logBlocks[i]);
            }
            ++i;
        }
        Trace.trace(TRACE_MASKF, " <- EventLogSummaryTasklet.getSecondaryBlocks()");
    }

    private void getThenDisplaySecondaryBlocks(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) {
        Trace.trace(TRACE_MASKF, " -> EventLogSummaryTasklet.getThenDisplaySecondaryBlocks()");
        this.getSecondaryBlocks();
        this._secondaryBlockIDSumBean = new SecondaryBlockIDSumBean();
        this._secondaryBlockIDSumBean.setLogSecondaryBlocks(this._logSecondaryBlocks);
        this._secondaryBlockIDSumBean.setEventLogData(this._createEventLogData.createEventLogData(this._logSelected));
        taskletResponse.openModalChild(AUIML_FILE_NAME, SECONDARY_BLOCKID_PANEL_NAME, this._secondaryBlockIDSumBean);
        Trace.trace(TRACE_MASKF, " <- EventLogSummaryTasklet.getThenDisplaySecondaryBlocks()");
    }

    private void displayFileNamePanel(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse, String fileNamePanel) {
        FileBean fileBean = new FileBean();
        fileBean.setFileNamePanel(fileNamePanel);
        taskletResponse.openModalChild(AUIML_FILE_NAME, FILE_PANEL_NAME, fileBean);
    }

    private void validateReadLogFileName(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse, String logFileName, int action) throws TaskletException {
        if (!logFileName.startsWith(File.separator)) {
            BaseMessageText myMess = null;
            myMess = new BaseMessageText("LOGDINVI");
            this.showMessageBox(true, _lEventTitle, myMess, null, null);
            taskletResponse.terminate();
        } else {
            this.readLogFileName(taskletRequest, taskletResponse, logFileName, action);
        }
    }

    private void readLogFileName(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse, String logFileName, int action) throws TaskletException {
        boolean fileExists = false;
        boolean canRead = false;
        boolean isFile = false;
        String dev = null;
        try {
            FileFn fileFn = new FileFn();
            dev = fileFn.queryMediaType(this, logFileName);
            File f = new File(logFileName);
            fileExists = f.exists();
            canRead = f.canRead();
            isFile = f.isFile();
        }
        catch (MediaServicesUtilException me) {
            Trace.trace(TRACE_MASKF, "Err determining type of device from where to read the log file");
            Trace.trace(TRACE_MASKF, me);
        }
        if (dev == null && fileExists && canRead && isFile) {
            this._logName = "!" + logFileName;
            Trace.trace(TRACE_MASKF, "name of log file to read =" + this._logName);
            this.readThenDisplayLogs(taskletRequest, taskletResponse);
        } else {
            Trace.trace(TRACE_MASKF, "log file to read =" + logFileName + " not found or accesible");
            LocalizableText lStrTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.filenameread.title");
            BaseMessageText myMess = new BaseMessageText("LOGDNTFI");
            this.showMessageBox(true, lStrTitle, myMess, null, null);
            if (action == 1) {
                taskletResponse.noAction();
            } else if (action == 3) {
                taskletResponse.terminate();
            }
        }
    }

    private void displayClassSelection(PanelTaskletResponse taskletResponse) throws TaskletException {
        Class logClass = class$com$ibm$hwmca$fw$log$LogClass == null ? (class$com$ibm$hwmca$fw$log$LogClass = EventLogSummaryTasklet.class$("com.ibm.hwmca.fw.log.LogClass")) : class$com$ibm$hwmca$fw$log$LogClass;
        Field[] fields = logClass.getDeclaredFields();
        int numFields = fields.length;
        this._classList = new ArrayList();
        int i = 0;
        while (i < numFields) {
            int modifiers = fields[i].getModifiers();
            if (fields[i].getType() == Byte.TYPE && Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                try {
                    this._classList.add(new Byte(fields[i].getByte(null)));
                }
                catch (IllegalAccessException ill) {
                    TaskletException te = new TaskletException(ill);
                    throw te;
                }
                this._classList.add(fields[i].getName());
            }
            ++i;
        }
        ClassSelectionBean classSelectionBean = new ClassSelectionBean();
        classSelectionBean.setClassList(this._classList);
        taskletResponse.openModalChild(AUIML_FILE_NAME, CLASS_LIST_PANEL_NAME, classSelectionBean);
    }

    public void handleRefcodeDisplayDesc(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        int eventLogDataIndex = this.getEventLogIndexes(taskletRequest);
        RetrieveRefcode retrieveRefcode = new RetrieveRefcode();
        try {
            EventLogData eventLogData = this._eventLogSummaryInfo.getEventLogData(eventLogDataIndex);
            retrieveRefcode.getDisplayRefcode(this, eventLogData);
        }
        catch (IOException exc) {
            Trace.trace(TRACE_MASKF, "There was an error retrieving the refcode description");
            TaskletException te = new TaskletException(exc);
            throw te;
        }
        taskletResponse.noAction();
    }

    public int getEventLogIndexes(PanelTaskletRequest taskletRequest) {
        Integer sel = (Integer)taskletRequest.getData("selected");
        this._eventSelected = sel;
        int startIndex = this._eventLogSummaryInfo.getStartIndex();
        int eventLogDataIndex = this._eventSelected - startIndex;
        Trace.trace(TRACE_MASKF, "eventSelected=" + this._eventSelected + " startIndex=" + startIndex + " eventLogDataIndex=" + eventLogDataIndex);
        return eventLogDataIndex;
    }

    public void displayViewFileList(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        this._logSelected = this.getSelectedLog(taskletRequest, taskletResponse, "viewFileList:");
        if (this._logSelected != null) {
            int eventLogDataIndex = this.getEventLogIndexes(taskletRequest);
            Trace.trace(TRACE_MASKF, "_logData's eventSelected=" + this._eventSelected + " viewFileListEventSelected=" + eventLogDataIndex);
            try {
                this._fileList = LogCollectionAgent.getFileList(this._logSelected);
                if (this._fileList == null || this._fileList.length == 0) {
                    BaseMessageText myMess = null;
                    myMess = new BaseMessageText("LOGNOFIL");
                    this.showMessageBox(true, _lEventTitle, myMess, null, null);
                    taskletResponse.noAction();
                } else {
                    Trace.trace(TRACE_MASKF, this._fileList.length + " fedc file/s returned from getFileList()");
                    FileDisplayerBean fileDisplayerBean = new FileDisplayerBean();
                    fileDisplayerBean.setEventLogData(this._eventLogSummaryInfo.getEventLogData(eventLogDataIndex));
                    fileDisplayerBean.setFileList(this._fileList);
                    this._fileDisplayerBeanName = fileDisplayerBean.getBeanName();
                    Trace.trace(TRACE_MASKF, " fileDisplayerBeanName=" + this._fileDisplayerBeanName);
                    taskletResponse.openModalChild(AUIML_FILE_NAME, FILE_LIST_PANEL_NAME, fileDisplayerBean);
                }
            }
            catch (HException exc) {
                Trace.trace(TRACE_MASKF, "There was an error retrieving the file list");
                TaskletException te = new TaskletException(exc);
                throw te;
            }
        }
    }

    public void logException(Throwable e) {
        Trace.trace(TRACE_MASKT, "-> EventLogSummaryTasklet.logException()");
        Trace.trace(TRACE_MASKF, e);
        new FrameworkLog(_logInfo, 1360, e).log();
        Trace.trace(TRACE_MASKT, "<- EventLogSummaryTasklet.logException()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Process pid = Runtime.getRuntime().exec("bbresrc");
            _refcodeProgramExists = true;
        }
        catch (IOException e) {
            _refcodeProgramExists = false;
            Trace.trace(TRACE_MASKF, "Default to No refcode description program.");
        }
    }
}

